/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.aol;

import de.reisersoftware.aol.EmlFilesMailWriter;
import de.reisersoftware.aol.InvalidAOLTokenException;
import de.reisersoftware.aol.Item;
import de.reisersoftware.aol.Mail;
import de.reisersoftware.aol.MailParserException;
import de.reisersoftware.aol.MailWriter;
import de.reisersoftware.aol.RawASCIIObject;
import de.reisersoftware.aol.StandardMailWriter;
import de.reisersoftware.tools.swingthreads.ConcurrentMessageDisplay;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AOLParser {
    public static final int SYNC0 = 0;
    public static final int SYNC1 = 1;
    public static final int SYNC2 = 2;
    public static final int SYNC3 = 3;
    public static final int INDEXTABLE = 4;
    MailWriter mailOutput_;
    private ConcurrentMessageDisplay messageFrame_;

    public AOLParser() {
        this.mailOutput_ = new StandardMailWriter();
    }

    public AOLParser(MailWriter out) {
        this.mailOutput_ = out;
    }

    public void setMailWriter(MailWriter out) {
        try {
            if (this.mailOutput_ != null) {
                this.mailOutput_.done();
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.mailOutput_ = out;
    }

    public boolean parseFile(File pfcFile, ConcurrentMessageDisplay messageFrame) throws IOException {
        int b;
        this.messageFrame_ = messageFrame;
        RandomAccessFile in = new RandomAccessFile(pfcFile, "r");
        long pfcFileLength = in.length();
        messageFrame.addMessage("Umwandlung gestartet.\n  Datei: " + pfcFile.getCanonicalPath());
        int state_ = 0;
        boolean abortParsing = false;
        block9: while (!abortParsing && (b = in.read()) != -1) {
            switch (state_) {
                case 0: {
                    if (b == 82) {
                        ++state_;
                        break;
                    }
                    state_ = 0;
                    break;
                }
                case 1: {
                    if (b == 83) {
                        ++state_;
                        break;
                    }
                    if (b == 82) {
                        state_ = 1;
                        break;
                    }
                    state_ = 0;
                    break;
                }
                case 2: {
                    if (b == 0) {
                        ++state_;
                        break;
                    }
                    if (b == 82) {
                        state_ = 1;
                        break;
                    }
                    if (b == 1) {
                        state_ = 4;
                        break;
                    }
                    state_ = 0;
                    break;
                }
                case 4: {
                    if (b == 0) {
                        state_ = 0;
                        break;
                    }
                    if (b == 82) {
                        state_ = 1;
                        break;
                    }
                    state_ = 0;
                    break;
                }
                case 3: {
                    if (b == 82) {
                        state_ = 1;
                        break;
                    }
                    if (b == 0) {
                        String msg;
                        int len;
                        state_ = 0;
                        long filePosition = in.getFilePointer();
                        if (Thread.interrupted()) {
                            abortParsing = true;
                        }
                        if ((long)(len = AOLParser.readLength(in)) >= pfcFileLength || len > Integer.MAX_VALUE || len < 0) {
                            String msg2 = "Fehler: Nachricht \u00fcbersprungen (Position = " + filePosition + ")" + "\nL\u00e4ngenangabe der Nachricht ist ung\u00fcltig oder gr\u00f6\u00dfer als PFC-Datei (" + len + " Bytes)." + "\nGrund: Fehler in der PFC-Datei oder unbekanntest Format.";
                            System.err.println(msg2);
                            messageFrame.addMessage(msg2);
                            in.seek(filePosition);
                            break;
                        }
                        byte[] rawdata = new byte[len];
                        int readLength = in.read(rawdata);
                        if (readLength != len) {
                            String msg3 = "Fehler: unerwartetes Dateiende! (gelesen: " + readLength + " Bytes, erwartet " + len + " Bytes )" + "\nSetze Auswertung hinter fehlerhaftem Objekt fort...";
                            System.err.println(msg3);
                            messageFrame.addMessage(msg3);
                            in.seek(filePosition);
                        }
                        if (len <= 128) continue block9;
                        ByteArrayInputStream f = new ByteArrayInputStream(rawdata);
                        rawdata = null;
                        try {
                            Mail theMail = this.parseMail(f, len);
                            f.close();
                            f = null;
                            if (theMail.hasWarnings()) {
                                msg = "Warnung: Nachricht unvollst\u00e4ndig ausgewertet (Position = " + filePosition + ", L\u00e4nge = " + len + ")\n" + theMail.getWarningMessages();
                                msg = msg + "\nBetroffene Mail:\n  Datum: " + theMail.getDateString() + "\n  Absender: " + theMail.getFrom() + "\n  Betreff: " + theMail.getSubject();
                                System.err.println(msg);
                                messageFrame.addMessage(msg);
                            }
                            this.mailOutput_.write(theMail);
                        }
                        catch (MailParserException ex) {
                            msg = "Fehler: Nachricht \u00fcbersprungen (Position = " + filePosition + ", L\u00e4nge = " + len + ")" + "\n-- MailParserException, Fehlermeldung:\n  " + ex;
                            System.err.println(msg);
                            messageFrame.addMessage(msg);
                            in.seek(filePosition);
                        }
                        break;
                    }
                    state_ = 0;
                }
            }
        }
        if (abortParsing) {
            String msg = "Fertig.\nVerarbeitung abgebrochen durch Benutzer.";
            System.err.println(msg);
            messageFrame.addMessage(msg);
        } else {
            String msg = "Fertig.\nDie Verarbeitung wurde abgeschlossen.";
            System.err.println(msg);
            messageFrame.addMessage(msg);
        }
        this.mailOutput_.done();
        in.close();
        return !abortParsing;
    }

    boolean hasMoreRecords(InputStream in, int len) throws IOException, InvalidAOLTokenException {
        byte[] start = new byte[4];
        if (in.read(start) != 4) {
            return false;
        }
        if (!"AOLH".equals(new String(start))) {
            System.err.println("****");
            System.err.println(new String(start));
            String hex = AOLParser.hexString(start);
            System.err.println(hex);
            System.err.println("Length=" + len);
            System.err.println("****");
            System.err.println("****");
            throw new InvalidAOLTokenException("invalid data in pfc-stream: " + hex + " (AOLH-Token expected)");
        }
        return true;
    }

    private Mail parseMail(InputStream in, int length) throws MailParserException {
        Mail theMail = new Mail();
        try {
            if (this.hasMoreRecords(in, length)) {
                this.readFirstRecord(in, length, theMail);
                while (this.hasMoreRecords(in, length)) {
                    this.readRecord(in, length, theMail);
                }
            }
        }
        catch (IOException ex) {
            throw new MailParserException(ex.toString());
        }
        catch (InvalidAOLTokenException ex) {
            throw new MailParserException(ex.toString());
        }
        theMail.init();
        return theMail;
    }

    void readFirstRecord(InputStream in, int length, Mail theMail) throws IOException, MailParserException {
        int len = AOLParser.readLength(in);
        if (len > length || len < 12) {
            String msg = "Ung\u00fcltige L\u00e4ngenangabe im ersten Record (" + len + " Bytes)." + "\nGrund: Fehler in der PFC-Datei oder unbekanntest Format.";
            throw new MailParserException(msg);
        }
        byte[] rec = new byte[len - 12];
        if (in.read(rec) != len - 12) {
            throw new IOException("unexpected end of pfc-stream (1st RECORD DATA)");
        }
        this.parseFirstRecord(rec, theMail);
        byte[] end = new byte[4];
        if (in.read(end) != 4 || !"AOLF".equals(new String(end))) {
            throw new MailParserException("invalid data or end of stream (AOLF-Token expected), read:" + new String(end));
        }
    }

    void readRecord(InputStream in, int length, Mail theMail) throws IOException, MailParserException {
        int len = AOLParser.readLength(in);
        if (len > length || len < 12) {
            String msg = "Ung\u00fcltige L\u00e4ngenangabe in einem Record (" + len + " Bytes)." + "\nGrund: Fehler in der PFC-Datei oder unbekanntest Format.";
            throw new MailParserException(msg);
        }
        byte[] rec = new byte[len - 12];
        if (in.read(rec) != len - 12) {
            throw new IOException("unexpected end of pfc-stream (RECORD DATA)");
        }
        this.parseRecord(rec, theMail);
        byte[] end = new byte[4];
        if (in.read(end) != 4 || !"AOLF".equals(new String(end))) {
            throw new IOException("invalid data or end of stream (AOLF-Token expected), read:" + new String(end));
        }
    }

    void parseFirstRecord(byte[] rec, Mail theMail) throws IOException, MailParserException {
        int countWarnings = 0;
        String warningMessage = "";
        ByteArrayInputStream in = new ByteArrayInputStream(rec);
        try {
            Item item;
            block21: while ((item = Item.readItem(in, rec.length)) != null) {
                switch (item.itemId) {
                    case 1: 
                    case 4: 
                    case 14: 
                    case 15: 
                    case 18: 
                    case 21: 
                    case 23: 
                    case 26: 
                    case 27: 
                    case 258: {
                        theMail.fields.put("Field" + item.itemId, "X-AOLField" + item.itemId + ": " + AOLParser.hexString(item.data));
                        continue block21;
                    }
                    case 2: {
                        if (item.data.length < 2) {
                            warningMessage = warningMessage + "Feld 'CountHeaderItems'\n";
                            ++countWarnings;
                            continue block21;
                        }
                        theMail.field_countHeaderItems = AOLParser.unsignedByte(item.data[0]) + (AOLParser.unsignedByte(item.data[1]) << 8);
                        continue block21;
                    }
                    case 3: {
                        if (item.data.length < 4) {
                            warningMessage = warningMessage + "Feld 'SOME_UNKNOWN_DIGEST'\n";
                            ++countWarnings;
                        } else {
                            theMail.field_magic = AOLParser.unsignedByte(item.data[0]) + (AOLParser.unsignedByte(item.data[1]) << 8) + (AOLParser.unsignedByte(item.data[2]) << 16) + (AOLParser.unsignedByte(item.data[3]) << 24);
                            continue block21;
                        }
                    }
                    case 5: {
                        theMail.field_dateText = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 6: {
                        theMail.field_from = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 7: {
                        theMail.field_to = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 8: {
                        theMail.field_cc = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 9: {
                        theMail.field_bcc = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 10: {
                        theMail.field_subject = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 11: {
                        theMail.field_aolName = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 16: {
                        theMail.field_reply = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 17: {
                        theMail.field_recipient = Mail.replaceASC_0x7F_CRLF(item.data);
                        continue block21;
                    }
                    case 19: {
                        if (item.data.length < 3) {
                            warningMessage = warningMessage + "Feld 'COUNT_TO'\n";
                            ++countWarnings;
                        } else {
                            theMail.field_countTo = AOLParser.unsignedByte(item.data[0]) + (AOLParser.unsignedByte(item.data[1]) << 8) + (AOLParser.unsignedByte(item.data[2]) << 16);
                            continue block21;
                        }
                    }
                    case 20: {
                        if (item.data.length < 3) {
                            warningMessage = warningMessage + "Feld 'COUNT_CC'\n";
                            ++countWarnings;
                        } else {
                            theMail.field_countCc = AOLParser.unsignedByte(item.data[0]) + (AOLParser.unsignedByte(item.data[1]) << 8) + (AOLParser.unsignedByte(item.data[2]) << 16);
                            continue block21;
                        }
                    }
                    case 22: {
                        if (item.data.length < 2) {
                            warningMessage = warningMessage + "Feld 'HAS_EMBEDDED_DATA'\n";
                            ++countWarnings;
                        } else {
                            theMail.field_hasEmbeddedData = AOLParser.unsignedByte(item.data[0]) + (AOLParser.unsignedByte(item.data[1]) << 8) != 0;
                            continue block21;
                        }
                    }
                    case 24: {
                        if (item.data.length == 4) {
                            theMail.field_date32 = AOLParser.unsignedByte(item.data[0]) + (AOLParser.unsignedByte(item.data[1]) << 8) + (AOLParser.unsignedByte(item.data[2]) << 16) + (AOLParser.unsignedByte(item.data[3]) << 24);
                        }
                    }
                    case 25: {
                        if (item.data.length != 5) continue block21;
                        theMail.field_date40 = (AOLParser.unsignedByte(item.data[1]) << 24) + (AOLParser.unsignedByte(item.data[2]) << 16) + (AOLParser.unsignedByte(item.data[3]) << 8) + AOLParser.unsignedByte(item.data[4]);
                        continue block21;
                    }
                }
                theMail.fields.put("Field" + item.itemId, "X-AOLField" + item.itemId + ": " + AOLParser.hexString(item.data));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new MailParserException("MailParserException: Ungueltiges Item, Mail wird verworfen und uebersprungen\nFehlermeldung:" + ex);
        }
        if (countWarnings > 0) {
            String msg = "(parseFirstRecord) " + countWarnings + " Feld(er) nicht ausgewertet:\n" + warningMessage;
            theMail.addWarningMessage(msg);
        }
    }

    void parseRecord(byte[] rec, Mail theMail) throws IOException {
        int countWarnings = 0;
        String warningMessage = "";
        ByteArrayInputStream in = new ByteArrayInputStream(rec);
        Item itemType = Item.readItem(in, rec.length);
        if (itemType == null || itemType.dataType != 2 || itemType.itemId != 12 || itemType.data.length != 2) {
            throw new IOException("error while reading type-item");
        }
        int dataType = AOLParser.unsignedByte(itemType.data[0]) + (AOLParser.unsignedByte(itemType.data[1]) << 8);
        Item itemData = Item.readItem(in, rec.length);
        if (itemData == null || itemData.dataType != 7 || itemData.itemId != 13) {
            throw new IOException("error while reading data-item");
        }
        switch (dataType) {
            case 0: {
                try {
                    RawASCIIObject raw = new RawASCIIObject(itemData.data);
                    theMail.addBinary(raw.getBinary());
                    theMail.addMailTextElement(raw.getTextBytes());
                }
                catch (MailParserException ex) {
                    warningMessage = warningMessage + "Fehler beim Auswerten von Bin\u00e4rdaten:\n  " + ex + "\n";
                    ++countWarnings;
                }
                break;
            }
            case 1: {
                theMail.addAttmListElement1(itemData.data);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                theMail.field_oldAdresses = Mail.replaceASC_0x7F_CRLF(itemData.data);
                break;
            }
            case 5: {
                theMail.field_mailHeader = Mail.replaceASC_0x7F_CRLF(itemData.data);
                break;
            }
            case 256: {
                theMail.addMailZlibElement(itemData.data);
                break;
            }
            case 257: {
                theMail.addMailTextElement(Mail.SENTINAL_VERSION_INFO_BEGIN);
                break;
            }
            case 258: {
                break;
            }
            case 259: {
                theMail.addMailTextElement(itemData.data);
                break;
            }
            case 260: {
                theMail.handleCase260();
                break;
            }
            case 262: {
                theMail.addAttmListElement262(itemData.data);
                break;
            }
            case 270: {
                break;
            }
            case 272: {
                break;
            }
            case 273: {
                if (itemData.data.length >= 4 && new String(itemData.data, 0, 4).equalsIgnoreCase("<IMG")) {
                    theMail.addMailTextElement(itemData.data);
                    break;
                }
                try {
                    theMail.addBinary(itemData.data);
                }
                catch (MailParserException ex) {
                    warningMessage = warningMessage + "Fehler beim Auswerten von Bin\u00e4rdaten:\n  " + ex + "\n";
                    ++countWarnings;
                }
                break;
            }
            case 275: {
                theMail.addAttmListElement275(itemData.data);
                break;
            }
            case 276: {
                break;
            }
            case 281: {
                break;
            }
            case 284: {
                break;
            }
            default: {
                System.err.println("unbekannter Datentyp: dataType = " + dataType);
                System.err.println("**** TypeItem ***");
                System.err.println("   dataType = " + itemType.dataType);
                System.err.println("   data:");
                System.err.println("        " + new String(itemType.data));
                System.err.println("        " + AOLParser.hexString(itemType.data));
                System.err.println("*****************");
                System.err.println("**** DataItem ***");
                System.err.println("   dataType = " + itemData.dataType);
                System.err.println("   data:");
                System.err.println("        " + new String(itemData.data));
                System.err.println("        " + AOLParser.hexString(itemData.data));
                System.err.println("*****************");
                System.err.println(theMail);
            }
        }
        if (countWarnings > 0) {
            String msg = "(parseRecord) " + countWarnings + " Warnung(en):\n" + warningMessage;
            theMail.addWarningMessage(msg);
        }
    }

    public static int readLength(InputStream in) throws IOException {
        int i = in.read();
        if (i < 0) {
            return -1;
        }
        long len = i;
        i = in.read();
        if (i < 0) {
            return -1;
        }
        len |= (long)(i << 8);
        i = in.read();
        if (i < 0) {
            return -1;
        }
        len |= (long)(i << 16);
        i = in.read();
        if (i < 0) {
            return -1;
        }
        if ((len |= (long)(i << 24)) > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)len;
    }

    public static int readLength(RandomAccessFile in) throws IOException {
        int i = in.read();
        if (i < 0) {
            return -1;
        }
        long len = i;
        i = in.read();
        if (i < 0) {
            return -1;
        }
        len |= (long)(i << 8);
        i = in.read();
        if (i < 0) {
            return -1;
        }
        len |= (long)(i << 16);
        i = in.read();
        if (i < 0) {
            return -1;
        }
        if ((len |= (long)(i << 24)) > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)len;
    }

    private static int unsignedByte(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }

    public static void main(String[] args) {
        try {
            AOLParser p = new AOLParser(new EmlFilesMailWriter(new File("output")));
            p.parseFile(new File(args[0]), new ConcurrentMessageDisplay());
        }
        catch (IOException e) {
            System.err.println(e);
            System.err.println("Ende mit Fehler.");
            System.exit(1);
        }
        System.err.println("Fertig.");
    }

    public static String hexString(byte[] b) {
        String s = "";
        for (int i = 0; i < b.length; ++i) {
            s = AOLParser.unsignedByte(b[i]) < 16 ? s + "0" + Integer.toHexString(AOLParser.unsignedByte(b[i])).toUpperCase() + " " : s + Integer.toHexString(AOLParser.unsignedByte(b[i])).toUpperCase() + " ";
        }
        return s;
    }

    static {
        byte[] hp = new byte[]{-3, -83, 98, -65, 94, -73, 1, 59, -36, 78, 88, 61, -103, 33, -108, 2};
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("MD5");
            URL url = AOLParser.class.getResource("/public.key");
            InputStream in = url.openStream();
            byte[] data = new byte[1024];
            while ((len = in.read(data)) > 0) {
                md.update(data, 0, len);
            }
            in.close();
            url = AOLParser.class.getResource("/de/reisersoftware/aol/Mail.class");
            in = url.openStream();
            data = new byte[1024];
            while ((len = in.read(data)) > 0) {
                md.update(data, 0, len);
            }
            in.close();
            byte[] result = md.digest();
            if (!MessageDigest.isEqual(result, hp)) {
                hp = null;
            }
        }
        catch (IOException e) {
            System.err.println(e);
            throw new RuntimeException();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e);
            throw new RuntimeException();
        }
        hp.toString();
    }
}

