/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.aol;

import de.reisersoftware.aol.Base64;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class BinaryObject {
    public String name_;
    public String id_;
    private Vector data_;
    private int maxEncLength_ = -1;

    public int getMaxEncodedLength() {
        if (this.maxEncLength_ > 0) {
            return this.maxEncLength_;
        }
        this.maxEncLength_ = 0;
        Enumeration e = this.data_.elements();
        while (e.hasMoreElements()) {
            this.maxEncLength_ += ((byte[])e.nextElement()).length;
        }
        this.maxEncLength_ = (int)((double)this.maxEncLength_ * 1.37);
        return this.maxEncLength_;
    }

    public void addElement(byte[] data) {
        this.data_.addElement(data);
    }

    public void addBinaryObject(BinaryObject obj) {
        this.data_.addAll(obj.data_);
    }

    public BinaryObject(String id, String name, Vector data) {
        this.id_ = id;
        this.name_ = name;
        this.data_ = data;
    }

    public BinaryObject(String dataTag, byte[] data) {
        this.id_ = BinaryObject.getIdFromDataTag(dataTag);
        this.name_ = BinaryObject.getNameFromDataTag(dataTag);
        this.data_ = new Vector();
        this.data_.addElement(data);
    }

    public static int getLengthFromDataTag(String s) {
        int i = s.indexOf(" SIZE");
        if (i == -1) {
            i = s.indexOf("\nSIZE");
        }
        if (i == -1) {
            i = s.indexOf(" DATASIZE");
        }
        if (i == -1) {
            i = s.indexOf("\nDATASIZE");
        }
        if (i == -1) {
            return -1;
        }
        i = s.indexOf(34, i);
        int result = Integer.parseInt(s.substring(i + 1, s.indexOf(34, i + 1)));
        return result;
    }

    public static String getIdFromDataTag(String s) {
        int i = s.indexOf(" ID");
        if (i == -1) {
            i = s.indexOf("\nID");
        }
        if (i == -1) {
            return "";
        }
        i = s.indexOf(34, i);
        return s.substring(i + 1, s.indexOf(34, i + 1));
    }

    public static String getNameFromDataTag(String s) {
        int i = s.indexOf(" NAME");
        if (i == -1) {
            i = s.indexOf("\nNAME");
        }
        if (i == -1) {
            return "";
        }
        i = s.indexOf(34, i);
        return s.substring(i + 1, s.indexOf(34, i + 1));
    }

    public void appendBase64(StringBuffer buffer) {
        Object[] elements = this.data_.toArray();
        this.data_.clear();
        ByteArrayOutputStream arrOut = new ByteArrayOutputStream();
        int byteCounter = 0;
        for (int i = 0; i < elements.length; ++i) {
            byte[] byteBuffer = (byte[])elements[i];
            elements[i] = null;
            for (int k = 0; k < byteBuffer.length; ++k) {
                arrOut.write(byteBuffer[k]);
                if (++byteCounter != 57) continue;
                byteCounter = 0;
                byte[] buf = arrOut.toByteArray();
                buffer.append(Base64.encodeBytes(buf, 8) + "\r\n");
                arrOut = new ByteArrayOutputStream();
            }
        }
        byte[] buf = arrOut.toByteArray();
        buffer.append(Base64.encodeBytes(buf, 8) + "\r\n");
        buffer.append("\r\n");
    }
}

