/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.aol;

import de.reisersoftware.aol.Mail;
import de.reisersoftware.aol.MailWriter;
import de.reisersoftware.aol.NiceLinebreaksFormatter;
import de.reisersoftware.pop3server.MailStore;
import de.reisersoftware.tools.Tools;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

public class EmlFilesMailWriter
implements MailWriter {
    private static final int BUFFER_LENGTH = 4096;
    private File outDir_;
    private BufferedWriter buf_;
    private int countTotal_ = 0;
    private int countSkipped_ = 0;
    private int countWritten_ = 0;
    private NiceLinebreaksFormatter wsf = new NiceLinebreaksFormatter();

    public EmlFilesMailWriter() {
    }

    public EmlFilesMailWriter(File outDir) throws IOException {
        this();
        if (!outDir.isDirectory()) {
            throw new IOException("Fehler: ungueltiges Ausgabeverzeichnis: " + outDir);
        }
        this.outDir_ = outDir;
    }

    public void write(Mail theMail) throws IOException {
        File theFile = Tools.getRandomFileName(this.outDir_, ".eml");
        BufferedWriter bufWriter = new BufferedWriter(new FileWriter(theFile));
        StringBuffer strBuf = theMail.toStringBuffer(false);
        this.wsf.foldAndWrite(strBuf, bufWriter);
        bufWriter.flush();
        bufWriter.close();
        ++this.countTotal_;
        try {
            long adler32 = MailStore.getAdler32(theFile);
            if (MailStore.moveFile_OrDeleteIfDuplicate(theFile, adler32) == null) {
                ++this.countSkipped_;
            } else {
                ++this.countWritten_;
            }
        }
        catch (FileNotFoundException ex) {
            System.err.println("-- warning: file " + theFile + " not found (possibly deleted by anti-virus-scanner).\n" + ex);
        }
        if (this.wsf.isLimitExceeded()) {
            System.err.println("-- warning: max line length limit exceeded.");
        }
    }

    public void done() throws IOException {
    }

    public void setDestination(File outDir) throws IOException {
        if (!outDir.isDirectory()) {
            throw new IOException("Fehler: ungueltiges Ausgabeverzeichnis: " + outDir);
        }
        this.outDir_ = outDir;
    }

    public int getMailsTotal() {
        return this.countTotal_;
    }

    public int getMailsSkipped() {
        return this.countSkipped_;
    }

    public int getMailsWritten() {
        return this.countWritten_;
    }

    public boolean countsSkippedMails() {
        return true;
    }
}

