/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.aol;

import de.reisersoftware.aol.AOLParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Item {
    public int itemId;
    public int dataType;
    public byte[] data;

    public static String toHexString(byte b) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        String ret = value < 16 ? "0" : "";
        ret = ret + Integer.toHexString(value).toUpperCase();
        return ret;
    }

    public Item(int id, int type, byte[] dat) {
        this.itemId = id;
        this.dataType = type;
        this.data = dat;
    }

    public static Item readItem(ByteArrayInputStream in, int length) throws IOException {
        int len2;
        int i = in.read();
        if (i == -1) {
            return null;
        }
        int iId = i;
        i = in.read();
        if (i == -1) {
            return null;
        }
        iId += i << 8;
        int dataType = in.read();
        if (dataType == -1) {
            return null;
        }
        switch (dataType) {
            case 1: {
                len2 = 1;
                break;
            }
            case 2: 
            case 3: {
                len2 = 2;
                break;
            }
            case 4: {
                len2 = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                len2 = AOLParser.readLength(in);
                if (len2 < length && len2 >= 0) break;
                throw new IOException("Item-L\u00e4nge ung\u00fcltig oder zu gro\u00df: ItemLength =" + len2 + ", RecordLength = " + length);
            }
            default: {
                boolean len2 = false;
                System.err.println("unknown data type: " + dataType);
                throw new IOException("unknown data type: " + dataType);
            }
        }
        byte[] data = new byte[len2];
        if (in.read(data) != len2) {
            throw new IOException("unexpected end of pfc-stream");
        }
        Item result = new Item(iId, dataType, data);
        return result;
    }

    static {
        byte[] hp = new byte[]{46, 54, -21, -42, 113, -84, -123, 11, -21, -125, 64, -88, 7, 50, 98, -88};
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("MD5");
            URL url = Item.class.getResource("/de/reisersoftware/aol/AOLParser.class");
            InputStream in = url.openStream();
            byte[] data = new byte[1024];
            while ((len = in.read(data)) > 0) {
                md.update(data, 0, len);
            }
            in.close();
            url = Item.class.getResource("/de/reisersoftware/aol/Mail.class");
            in = url.openStream();
            data = new byte[1024];
            while ((len = in.read(data)) > 0) {
                md.update(data, 0, len);
            }
            in.close();
            byte[] result = md.digest();
            if (!MessageDigest.isEqual(result, hp)) {
                hp = null;
            }
        }
        catch (IOException e) {
            System.err.println(e);
            throw new RuntimeException();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e);
            throw new RuntimeException();
        }
        hp.toString();
    }
}

