/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.aol;

import de.reisersoftware.aol.AOLParser;
import de.reisersoftware.aol.AttachmentList;
import de.reisersoftware.aol.BinaryObject;
import de.reisersoftware.aol.MailParserException;
import de.reisersoftware.aol.MimeTypesList;
import de.reisersoftware.aol.Registrierung;
import de.reisersoftware.aol.UnicodeTools;
import de.reisersoftware.umzugshelferclassic.AppUmzugshelferClassic;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.Inflater;

public class Mail {
    public static final String UNDEFINED_FROM = "unknown@unknown.host";
    private int unknownCounter_ = 0;
    private String parserWarnings_ = "";
    private int countWarnings_ = 0;
    public static final byte[] SENTINAL_VERSION_INFO_BEGIN;
    public static final byte[] SENTINAL_VERSION_INFO_END;
    public static final String HEADER_SEPARATOR = "----------------------- Headers --------------------------------";
    public static final GregorianCalendar REFDATE_OLD;
    public static final GregorianCalendar REFDATE_NEW;
    private Random rnd_;
    public Hashtable fields = new Hashtable();
    public boolean field_hasEmbeddedData = false;
    public int field_countHeaderItems = -1;
    public long field_magic = -1L;
    public int field_countTo = -1;
    public int field_countCc = -1;
    public long field_date32 = -1L;
    public long field_date40 = -1L;
    public byte[] field_dateText = null;
    private boolean isLocalTimeZone_ = false;
    public byte[] field_from = null;
    public byte[] field_to = null;
    public byte[] field_cc = null;
    public byte[] field_bcc = null;
    public byte[] field_subject = null;
    public byte[] field_aolName = null;
    public byte[] field_reply = null;
    public byte[] field_recipient = null;
    public byte[] field_oldAdresses = null;
    public byte[] field_mailHeader = null;
    private StringBuffer mailBodyString_ = null;
    private Vector mailText = new Vector();
    private Vector mailZlib = new Vector();
    private Vector mailOldHeaders = new Vector();
    private Hashtable binaryData = new Hashtable();
    private AttachmentList attmList = new AttachmentList();
    private String contentType_ = "";
    private String boundary_ = "";
    private boolean hasBoundary_ = false;
    private int cid_ = 0;
    private boolean isPlainText_;
    private GregorianCalendar theEvaluatedDate_ = null;

    public void addWarningMessage(String msg) {
        this.parserWarnings_ = this.parserWarnings_ + msg;
        ++this.countWarnings_;
    }

    public String getWarningMessages() {
        return this.parserWarnings_;
    }

    public boolean hasWarnings() {
        return !this.parserWarnings_.equals("");
    }

    private void initRandom(String text) {
        Adler32 adler32 = new Adler32();
        adler32.update(text.getBytes());
        this.rnd_ = new Random(adler32.getValue());
    }

    public void addMailTextElement(Object o) {
        this.mailText.addElement(o);
    }

    public void addMailZlibElement(Object o) {
        this.mailZlib.addElement(o);
    }

    public void addAttmListElement1(byte[] data) {
        this.attmList.add1(data);
    }

    public void addAttmListElement262(byte[] data) {
        this.attmList.add262(data);
    }

    public void addAttmListElement275(byte[] data) {
        this.attmList.add275(data);
    }

    public void init() {
        this.theEvaluatedDate_ = this.getDate();
    }

    public GregorianCalendar getDate() {
        if (this.theEvaluatedDate_ == null) {
            this.theEvaluatedDate_ = this.computeDate();
        }
        return this.theEvaluatedDate_;
    }

    private GregorianCalendar extractDateFromText(byte[] dateString) {
        GregorianCalendar result = REFDATE_NEW;
        String str = "_EMPTY_";
        try {
            int jj;
            str = new String(dateString).trim();
            StringTokenizer tocAll = new StringTokenizer(str, " ");
            String strDatePart = tocAll.nextToken();
            StringTokenizer tocDate = new StringTokenizer(strDatePart, ".-/");
            int tt = Integer.parseInt(tocDate.nextToken());
            int mm = Integer.parseInt(tocDate.nextToken()) - 1;
            if (mm > 11) {
                int help = tt;
                tt = mm + 1;
                mm = help - 1;
            }
            if ((jj = Integer.parseInt(tocDate.nextToken())) < 60) {
                jj = 2000 + jj;
            } else if (jj < 200) {
                jj = 1900 + jj;
            }
            result = new GregorianCalendar(jj, 0, 1, 0, 0, 0);
            result = new GregorianCalendar(jj, mm, tt, 0, 0, 0);
            int h = 0;
            int m = 0;
            int s = 0;
            if (tocAll.hasMoreTokens()) {
                String strTimePart = tocAll.nextToken();
                StringTokenizer tocTime = new StringTokenizer(strTimePart, ":");
                h = Integer.parseInt(tocTime.nextToken());
                m = Integer.parseInt(tocTime.nextToken());
                if (tocTime.hasMoreTokens()) {
                    s = Integer.parseInt(tocTime.nextToken().substring(0, 2));
                }
            }
            result = new GregorianCalendar(jj, mm, tt, h, m, s);
        }
        catch (Exception ex) {
            String errMsg = ex + "\nDatum konnte nicht ausgewertet werden: '" + str + "'";
            System.err.println(errMsg);
            this.addWarningMessage(errMsg);
            System.err.println("-------" + this.hasWarnings());
        }
        catch (Throwable ex) {
            String errMsg = ex + "\nDatum konnte nicht ausgewertet werden: '" + str + "'";
            System.err.println(errMsg);
            this.addWarningMessage(errMsg);
        }
        return result;
    }

    private GregorianCalendar computeDate() {
        long date;
        GregorianCalendar theTextDate = this.extractDateFromText(this.field_dateText);
        int theYear = theTextDate.get(1);
        if (this.field_date32 != -1L) {
            date = this.field_date32;
        } else if (this.field_date40 != -1L) {
            date = this.field_date40;
        } else {
            this.isLocalTimeZone_ = true;
            return theTextDate;
        }
        GregorianCalendar cal = (GregorianCalendar)REFDATE_OLD.clone();
        cal.add(13, (int)date);
        if (theYear - 1 <= cal.get(1) && cal.get(1) <= theYear + 1) {
            return cal;
        }
        cal = (GregorianCalendar)REFDATE_NEW.clone();
        cal.add(13, (int)date);
        if (theYear - 1 <= cal.get(1) && cal.get(1) <= theYear + 1) {
            return cal;
        }
        this.isLocalTimeZone_ = true;
        return theTextDate;
    }

    private String getAsctime() {
        GregorianCalendar cal = this.getDate();
        String result = "";
        int DOW = cal.get(7);
        switch (DOW) {
            case 1: {
                result = "Sun ";
                break;
            }
            case 2: {
                result = "Mon ";
                break;
            }
            case 3: {
                result = "Tue ";
                break;
            }
            case 4: {
                result = "Wed ";
                break;
            }
            case 5: {
                result = "Thu ";
                break;
            }
            case 6: {
                result = "Fri ";
                break;
            }
            case 7: {
                result = "Sat ";
            }
        }
        int MON = cal.get(2);
        switch (MON) {
            case 0: {
                result = result + "Jan ";
                break;
            }
            case 1: {
                result = result + "Feb ";
                break;
            }
            case 2: {
                result = result + "Mar ";
                break;
            }
            case 3: {
                result = result + "Apr ";
                break;
            }
            case 4: {
                result = result + "May ";
                break;
            }
            case 5: {
                result = result + "Jun ";
                break;
            }
            case 6: {
                result = result + "Jul ";
                break;
            }
            case 7: {
                result = result + "Aug ";
                break;
            }
            case 8: {
                result = result + "Sep ";
                break;
            }
            case 9: {
                result = result + "Oct ";
                break;
            }
            case 10: {
                result = result + "Nov ";
                break;
            }
            case 11: {
                result = result + "Dec ";
            }
        }
        int DAY = cal.get(5);
        if (DAY < 10) {
            result = result + "0";
        }
        result = result + DAY + " ";
        int HH = cal.get(11);
        if (HH < 10) {
            result = result + "0";
        }
        result = result + HH + ":";
        int MM = cal.get(12);
        if (MM < 10) {
            result = result + "0";
        }
        result = result + MM + ":";
        int SS = cal.get(13);
        if (SS < 10) {
            result = result + "0";
        }
        result = result + SS + " ";
        result = result + cal.get(1);
        result = !this.isLocalTimeZone_ ? result + " +0000" : result + " -0000";
        return result;
    }

    public String getDateString() {
        String result;
        GregorianCalendar cal = this.getDate();
        int DOW = cal.get(7);
        switch (DOW) {
            case 1: {
                result = "Sun, ";
                break;
            }
            case 2: {
                result = "Mon, ";
                break;
            }
            case 3: {
                result = "Tue, ";
                break;
            }
            case 4: {
                result = "Wed, ";
                break;
            }
            case 5: {
                result = "Thu, ";
                break;
            }
            case 6: {
                result = "Fri, ";
                break;
            }
            case 7: {
                result = "Sat, ";
                break;
            }
            default: {
                result = "";
            }
        }
        int DAY = cal.get(5);
        if (DAY < 10) {
            result = result + "0";
        }
        result = result + DAY + " ";
        int MON = cal.get(2);
        switch (MON) {
            case 0: {
                result = result + "Jan ";
                break;
            }
            case 1: {
                result = result + "Feb ";
                break;
            }
            case 2: {
                result = result + "Mar ";
                break;
            }
            case 3: {
                result = result + "Apr ";
                break;
            }
            case 4: {
                result = result + "May ";
                break;
            }
            case 5: {
                result = result + "Jun ";
                break;
            }
            case 6: {
                result = result + "Jul ";
                break;
            }
            case 7: {
                result = result + "Aug ";
                break;
            }
            case 8: {
                result = result + "Sep ";
                break;
            }
            case 9: {
                result = result + "Oct ";
                break;
            }
            case 10: {
                result = result + "Nov ";
                break;
            }
            case 11: {
                result = result + "Dec ";
            }
        }
        result = result + cal.get(1) + " ";
        int HH = cal.get(11);
        if (HH < 10) {
            result = result + "0";
        }
        result = result + HH + ":";
        int MM = cal.get(12);
        if (MM < 10) {
            result = result + "0";
        }
        result = result + MM + ":";
        int SS = cal.get(13);
        if (SS < 10) {
            result = result + "0";
        }
        result = result + SS;
        result = !this.isLocalTimeZone_ ? result + " +0000" : result + " -0000";
        return result;
    }

    private String makeSeparator() {
        String separator = "From - " + this.getAsctime() + AppUmzugshelferClassic.T.toString();
        return separator;
    }

    private String formatRecipients(String fieldName, byte[] dataBytes) {
        String data = null;
        if (dataBytes != null) {
            data = new String(dataBytes).trim();
        }
        String result = "";
        if (data != null && !data.trim().equals("")) {
            StringTokenizer tok = new StringTokenizer(data, "\r\n,");
            String s = "";
            if (tok.hasMoreTokens()) {
                s = Mail.correctAOLAddress(tok.nextToken().trim());
            }
            while (tok.hasMoreTokens()) {
                String t = Mail.correctAOLAddress(tok.nextToken().trim());
                if (t.equals("")) continue;
                s = s + ", " + t;
            }
            result = result + "\r\n" + fieldName + s;
        }
        return result;
    }

    private String makeOriginalHeader() {
        String result = "";
        if (this.field_mailHeader != null && this.field_mailHeader.length != 0) {
            String origheader = new String(this.field_mailHeader).trim();
            BufferedReader in = new BufferedReader(new StringReader(origheader));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    result = result + "\r\nX-AOL-ORIGINAL_HEADER: " + line;
                }
            }
            catch (Exception e) {
                System.err.println("Mail.makeOriginalHeader(): " + e);
            }
        }
        return result;
    }

    private static String correctAOLAddress(String address) {
        if (address.indexOf(64) != -1) {
            return address;
        }
        StringTokenizer tok = new StringTokenizer(address, " ");
        String result = "";
        while (tok.hasMoreTokens()) {
            result = result + tok.nextToken();
        }
        if (result.equals("")) {
            return "";
        }
        result = result + "@aol.com";
        return result;
    }

    public String getFrom() {
        String strFrom = null;
        String strAOLName = null;
        if (this.field_from != null) {
            strFrom = Mail.correctAOLAddress(new String(this.field_from).trim());
        }
        if (this.field_aolName != null) {
            strAOLName = Mail.correctAOLAddress(new String(this.field_aolName)).trim();
        }
        String result = strFrom == null || strFrom.equals("") ? (strAOLName == null || strAOLName.equals("") ? UNDEFINED_FROM : strAOLName) : strFrom;
        return result;
    }

    public String getSubject() {
        String strSubject = null;
        if (this.field_subject != null && (strSubject = UnicodeTools.utf8encodeWord(UnicodeTools.unknownToUTF8(this.field_subject))) != null) {
            strSubject = strSubject.trim();
        }
        return strSubject;
    }

    private String makeHeader() {
        String header = "";
        header = header + "Date: " + this.getDateString();
        header = header + "\r\nFrom: " + this.getFrom();
        header = header + "\r\nSubject: ";
        String strSubject = this.getSubject();
        if (strSubject != null && !strSubject.equals("")) {
            header = header + strSubject;
        }
        String strRecip = null;
        if (this.field_recipient != null) {
            strRecip = Mail.correctAOLAddress(new String(this.field_recipient).trim());
        }
        if (strRecip != null && !strRecip.equals("")) {
            header = header + "\r\nRecipient: " + strRecip;
        }
        header = header + this.formatRecipients("To: ", this.field_to);
        header = header + this.formatRecipients("Cc: ", this.field_cc);
        header = header + this.formatRecipients("Bcc: ", this.field_bcc);
        String strReply = null;
        if (this.field_reply != null) {
            strReply = Mail.correctAOLAddress(new String(this.field_reply).trim());
        }
        if (strReply != null && !strReply.equals("")) {
            header = header + "\r\nReply: " + strReply;
        }
        header = header + this.makeOriginalHeader();
        String strOldAdresses = null;
        if (this.field_oldAdresses != null) {
            strOldAdresses = new String(this.field_oldAdresses).trim();
        }
        if (strOldAdresses != null) {
            BufferedReader in = new BufferedReader(new StringReader(strOldAdresses));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    header = header + "\r\nX-AOL-ORIGINAL_ADDRESSES: " + line;
                }
            }
            catch (Exception e) {
                System.err.println("Mail.makeHeader(): " + e);
            }
        }
        Enumeration e = this.fields.elements();
        while (e.hasMoreElements()) {
            header = header + "\r\n" + (String)e.nextElement();
        }
        return header;
    }

    private String createBoundary() {
        String sep = this.field_date32 != -1L ? Long.toHexString(this.field_date32) : "EFCDAB1032547698";
        return "----------------BOUNDARY" + sep;
    }

    private void formatMail(StringBuffer body, boolean useSeparator) {
        String header = this.makeHeader();
        this.initRandom(header);
        this.makeBody(body);
        Enumeration e = this.mailOldHeaders.elements();
        String oldheader = "";
        while (e.hasMoreElements()) {
            BufferedReader hr = new BufferedReader(new StringReader((String)e.nextElement()));
            try {
                String line;
                while ((line = hr.readLine()) != null) {
                    oldheader = oldheader + "\r\nX-AOL-OLD_HEADER: " + line;
                }
            }
            catch (Exception ex) {
                System.err.println("Mail.formatMail() " + ex);
            }
        }
        this.isPlainText_ = !Mail.guessContentTypeIsHTML(body, header, oldheader);
        header = header + oldheader;
        this.replaceNewlines(body);
        if (!this.isPlainText_) {
            int pos = body.indexOf("<EMBED ");
            while (pos != -1) {
                body.delete(pos, pos + 7);
                body.insert(pos, "<img ");
                pos = body.indexOf("<EMBED ");
            }
        }
        this.maskFromAtBeginningOfLine(body);
        this.contentType_ = this.isPlainText_ ? "Content-Type: text/plain; charset=utf-8" : "Content-Type: text/html; charset=utf-8";
        this.boundary_ = this.createBoundary();
        this.hasBoundary_ = false;
        if (!this.attmList.isEmpty()) {
            this.hasBoundary_ = true;
            this.contentType_ = "Content-Type: multipart/mixed; boundary=\"" + this.boundary_ + "\"";
        }
        if (this.binaryData.size() > 0) {
            this.contentType_ = "Content-Type: multipart/related; boundary=\"" + this.boundary_ + "\"";
            this.hasBoundary_ = true;
        }
        if (!this.hasBoundary_ && body.length() > 300 && !Registrierung.isRegistered()) {
            int len = body.length() * 2 / 3;
            body.delete(len, body.length());
            if (this.isPlainText_) {
                body.insert(0, "\r\n\r\n=== SHAREWARE-HINWEIS ===\r\nDer Text dieser Nachricht wurde um ein drittel gekuerzt.\r\nDie Nachricht wurde mit der Shareware-Version des\r\nE-Mail-Umzugshelfers erzeugt.\r\nDie Vollversion ist unter\r\nhttp://www.reiser-software.de erhaeltlich.\r\n-------------------------\r\n");
            } else {
                body.insert(0, "\r\n<center><b>=== SHAREWARE-HINWEIS ===</b>\r\n<br>Der Text dieser Nachricht wurde um ein drittel gek&uuml;rzt.\r\n<br>Die Nachricht wurde mit der Shareware-Version des E-Mail-Umzugshelfers erzeugt.\r\n<br>Die Vollversion ist unter <a href=\"http://www.reiser-software.de\">http://www.reiser-software.de</a> erh&auml;ltlich.\r\n</center><hr>\r\n");
            }
        }
        String res = "";
        if (useSeparator) {
            res = res + this.makeSeparator() + "\r\n";
        }
        res = res + header + "\r\n" + this.contentType_ + "\r\nMIME-Version: 1.0" + "\r\nContent-transfer-encoding: 8bit" + "\r\n\r\n";
        header = null;
        if (this.hasBoundary_) {
            res = res + "This is a multipart message in MIME-Format.\r\n\r\n--" + this.boundary_ + "\r\n";
            res = this.isPlainText_ ? res + "Content-Type: text/plain; charset=utf-8\r\n\r\n" : res + "Content-Type: text/html; charset=utf-8\r\n\r\n";
        }
        body.insert(0, res);
        res = null;
        this.appendBinary(body);
        if (!this.attmList.isEmpty()) {
            body.append("\r\n--" + this.boundary_ + "\r\nContent-Type: text/plain; charset=utf-8; name=\"Dateiliste.txt\"" + "\r\nContent-Disposition: INLINE; filename=\"Dateiliste.txt\"\r\n\r\n" + this.attmList.toString());
        }
        if (this.hasBoundary_) {
            body.append("\r\n--" + this.boundary_ + "--");
        }
    }

    private void makeBody(StringBuffer body) {
        int pos;
        boolean nowHeaderFollows = false;
        Enumeration e = this.mailText.elements();
        while (e.hasMoreElements()) {
            byte[] elem = (byte[])e.nextElement();
            if (elem.equals(SENTINAL_VERSION_INFO_BEGIN) || elem.equals(SENTINAL_VERSION_INFO_END)) continue;
            String str = new String(UnicodeTools.unknownToUTF8(elem));
            if (nowHeaderFollows) {
                this.mailOldHeaders.addElement(str);
                continue;
            }
            pos = str.indexOf(HEADER_SEPARATOR);
            if (-1 != pos) {
                body.append(str.substring(0, pos));
                this.mailOldHeaders.addElement(str.substring(pos));
                nowHeaderFollows = true;
                continue;
            }
            body.append(str);
        }
        this.mailText.clear();
        if (this.mailZlib.size() > 0) {
            body.append(this.inflate(this.mailZlib));
        }
        this.mailZlib.clear();
        pos = 0;
        String ZERO = "\u0000";
        while ((pos = body.indexOf(ZERO, pos)) != -1) {
            body.deleteCharAt(pos);
        }
    }

    private void maskFromAtBeginningOfLine(StringBuffer body) {
        if (body.indexOf("From ") == 0) {
            body.insert(0, " ");
        }
        int pos = 0;
        while ((pos = body.indexOf("\r\nFrom ", pos)) != -1) {
            body.insert(pos + 2, " ");
        }
        pos = 0;
        while ((pos = body.indexOf("\nFrom ", pos)) != -1) {
            body.insert(pos + 1, " ");
        }
        pos = 0;
        while ((pos = body.indexOf("\rFrom ", pos)) != -1) {
            body.insert(pos + 1, " ");
        }
    }

    private void appendBinary(StringBuffer mailBody) {
        BinaryObject bObj;
        Object[] elements = this.binaryData.values().toArray();
        this.binaryData.clear();
        int mem = 0;
        for (int j = 0; j < elements.length; ++j) {
            bObj = (BinaryObject)elements[j];
            mem += bObj.getMaxEncodedLength();
        }
        mailBody.ensureCapacity(mem + mailBody.length() + 102400);
        for (int i = 0; i < elements.length; ++i) {
            bObj = (BinaryObject)elements[i];
            this.append_encodeBinaryObject(bObj, mailBody);
        }
    }

    private void replaceNewlines(StringBuffer text) {
        if (this.isPlainText_) {
            Mail.replaceASC_0x7F_CRLF_Str(text);
            return;
        }
        int mode = 0;
        block0: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                mode = -1;
                continue;
            }
            if (ch == '>') {
                mode = 0;
                continue;
            }
            if (ch != '\u007f') continue;
            if (mode == -1) {
                text.setCharAt(i, '\r');
                text.insert(i + 1, '\n');
                continue;
            }
            for (int j = i + 1; j < text.length(); ++j) {
                ch = text.charAt(j);
                if (ch == ' ') continue;
                if (ch == '<') {
                    text.setCharAt(i, '\r');
                    text.insert(i + 1, '\n');
                    continue block0;
                }
                text.setCharAt(i, '<');
                text.insert(i + 1, "br>\r\n");
                continue block0;
            }
        }
    }

    private static void replaceASC_0x7F_CRLF_Str(StringBuffer strData) {
        for (int i = 0; i < strData.length(); ++i) {
            if (strData.charAt(i) != '\u007f') continue;
            strData.setCharAt(i, '\r');
            strData.insert(i + 1, '\n');
        }
    }

    public static byte[] replaceASC_0x7F_CRLF(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 512);
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            byte b = data[i];
            if (b == 127) {
                out.write(13);
                out.write(10);
                continue;
            }
            out.write(data[i]);
        }
        return out.toByteArray();
    }

    public StringBuffer toStringBuffer(boolean useSeparator) {
        if (this.mailBodyString_ != null) {
            return this.mailBodyString_;
        }
        this.mailBodyString_ = new StringBuffer();
        this.formatMail(this.mailBodyString_, useSeparator);
        this.mailBodyString_.append("\r\n\r\n");
        return this.mailBodyString_;
    }

    public static void main(String[] args) {
        Mail m = new Mail();
        System.out.println(m.getAsctime());
        String s = "dfsjkd\n\n\n";
        System.out.println("---");
        System.out.println(s);
        System.out.println("---");
        System.out.println(s.trim());
        System.out.println("---");
    }

    private String inflate(Vector vec) {
        String result = "";
        Object[] elements = vec.toArray();
        vec.clear();
        byte[] data = new byte[]{};
        try {
            Inflater decompresser = new Inflater(true);
            byte[] res = new byte[131072];
            for (int index = 0; index < elements.length; ++index) {
                data = (byte[])elements[index];
                elements[index] = null;
                if (index < elements.length - 1 && data.length == 2 && data[0] == 120 && data[1] == -100) {
                    decompresser.end();
                    decompresser = new Inflater(true);
                    continue;
                }
                decompresser.setInput(data, 0, data.length);
                int len = 0;
                do {
                    len = decompresser.inflate(res);
                    result = result + new String(UnicodeTools.unknownToUTF8(res, 0, len));
                } while (len > 0);
            }
        }
        catch (Exception en) {
            System.err.println(en);
            result = "\r\n*** FEHLER IN DEN ZLIB-GEPACKTEN DATEN. MAIL KONNTE NICHT ENTPACKT WERDEN. ***";
        }
        return result;
    }

    public void addBinary(Hashtable tab) {
        if (tab.isEmpty()) {
            return;
        }
        Enumeration keys = tab.keys();
        while (keys.hasMoreElements()) {
            String id = (String)keys.nextElement();
            this.addBinary((BinaryObject)tab.get(id));
        }
    }

    public void addBinary(byte[] data) throws MailParserException {
        try {
            int p = -1;
            if (data.length > 5 && new String(data, 0, 5).equalsIgnoreCase("<DATA")) {
                p = 4;
            } else if (data.length > 13 && new String(data, 8, 5).equalsIgnoreCase("<DATA")) {
                p = 12;
            }
            if (p > -1) {
                while (p < data.length && data[p] != 62) {
                    ++p;
                }
                if (p >= data.length) {
                    throw new MailParserException("Fehler beim Verarbeiten von Bin\u00e4rdaten (Mail.addBinary()):\n   DATA-Tag ist nicht abgeschlossen.");
                }
                String dataTag = new String(data, 8, p - 7);
                int len = BinaryObject.getLengthFromDataTag(dataTag);
                if (len > data.length || len < -1) {
                    throw new MailParserException("Fehler (Mail.addBinary()):\n   Ung\u00fcltige L\u00e4ngenangabe in Bin\u00e4rdaten. (len=" + len + ")");
                }
                byte[] dt = new byte[len];
                for (int i = 0; i < len; ++i) {
                    dt[i] = data[i + p + 1];
                }
                BinaryObject bObj = new BinaryObject(dataTag, dt);
                this.addBinary(bObj);
            }
        }
        catch (Exception ex) {
            String msg = "Fehler: Problem mit Bin\u00e4rdaten (allgemeine Exception).\n" + ex.toString();
            System.err.println(msg);
            System.err.println(new String(data));
            System.err.println(AOLParser.hexString(data));
            throw new MailParserException(msg);
        }
        catch (Throwable ex) {
            String msg = "Fehler: Problem mit Bin\u00e4rdaten (Throwable).\n" + ex.toString();
            System.err.println(msg);
            throw new MailParserException(msg);
        }
    }

    private void addBinary(BinaryObject bObj) {
        if (this.binaryData.get(bObj.id_) == null) {
            this.binaryData.put(bObj.id_, bObj);
        } else {
            BinaryObject bObj2 = (BinaryObject)this.binaryData.get(bObj.id_);
            bObj2.addBinaryObject(bObj);
        }
    }

    private void append_encodeBinaryObject(BinaryObject bObj, StringBuffer mailBody) {
        String contentType;
        String url;
        String refTag;
        String filename = bObj.name_;
        if (filename.equals("")) {
            filename = "unknown" + this.unknownCounter_++;
        }
        String ext = "";
        ++this.cid_;
        String cid = "cid" + this.cid_ + Long.toHexString(this.rnd_.nextLong()) + Long.toHexString(this.rnd_.nextLong());
        int[] refTagLimit = this.extractRefTag(mailBody, bObj.id_, 0);
        if (refTagLimit[0] > -1 && refTagLimit[1] > refTagLimit[0]) {
            refTag = mailBody.substring(refTagLimit[0], refTagLimit[1]);
            url = this.extractSourceURLFromRefTag(refTag);
        } else {
            refTag = "";
            url = "";
        }
        if (!url.equals("")) {
            String fname = this.extractFilenameFromSourceURL(url);
            if (!fname.equals("")) {
                filename = fname;
                bObj.name_ = fname;
            }
            do {
                String subStr = mailBody.substring(refTagLimit[0], refTagLimit[1]).toLowerCase();
                int startPos = refTagLimit[0] + subStr.indexOf(url.toLowerCase());
                int endPos = startPos + url.length();
                if (startPos <= -1) continue;
                mailBody.delete(startPos, endPos);
                mailBody.insert(startPos, "cid:" + cid);
                refTagLimit[1] = startPos + 4;
            } while ((refTagLimit = this.extractRefTag(mailBody, bObj.id_, refTagLimit[1]))[0] != -1);
        }
        if ((contentType = MimeTypesList.getMimeType(ext = this.extractExtensionFromFilename(filename))) == null) {
            contentType = "application/octet-stream";
        }
        mailBody.append("\r\n--" + this.boundary_ + "\r\nContent-Type: " + contentType + "; name=\"" + filename + "\"" + "\r\nContent-Id: <" + cid + ">" + "\r\nContent-Disposition: ATTACHMENT" + "\r\nContent-Transfer-Encoding: base64" + "\r\n\r\n");
        bObj.appendBase64(mailBody);
    }

    private int[] extractRefTag(StringBuffer body, String id, int startAt) {
        int[] result = new int[]{-1, -1};
        int start = startAt;
        int ausschnitt = 65536;
        int partEnd = start + 2 * id.length() + ausschnitt;
        int pos = -1;
        while (start < body.length()) {
            String part;
            if (partEnd > body.length()) {
                partEnd = body.length();
            }
            if ((pos = (part = body.substring(start, partEnd).toLowerCase()).indexOf("id=\"" + id.toLowerCase() + "\"")) != -1) {
                pos += start;
                break;
            }
            start += ausschnitt;
            partEnd += ausschnitt;
        }
        if (pos != -1) {
            int begin = pos;
            int end = pos;
            boolean ok = false;
            while (begin >= startAt) {
                if (body.charAt(--begin) != '<') continue;
                ok = true;
                break;
            }
            if (ok) {
                ok = false;
                while (end < body.length() - 1) {
                    if (body.charAt(++end) != '>') continue;
                    ok = true;
                    break;
                }
                if (ok) {
                    result[0] = begin;
                    result[1] = end + 1;
                }
            }
        }
        return result;
    }

    private String extractSourceURLFromRefTag(String tag) {
        int j;
        int i;
        String result = "";
        int pos = tag.toLowerCase().indexOf(" src=");
        if (pos == -1) {
            pos = tag.toLowerCase().indexOf("\nsrc=");
        }
        if (pos != -1 && (i = tag.indexOf("\"", pos + 5)) != -1 && (j = tag.indexOf("\"", i + 1)) != -1) {
            result = tag.substring(i + 1, j);
        }
        return result;
    }

    private String extractFilenameFromSourceURL(String url) {
        String result = "";
        int pos = url.lastIndexOf(47);
        if (pos < url.length() - 1) {
            result = url.substring(pos + 1);
        }
        return result;
    }

    private String extractExtensionFromFilename(String filename) {
        String result = "";
        int pos = filename.lastIndexOf(46);
        if (pos != -1 && pos < filename.length() - 1) {
            result = filename.substring(pos);
        }
        return result;
    }

    private static boolean guessContentTypeIsHTML(StringBuffer text, String header, String oldheader) {
        String h = header.toLowerCase();
        String oh = oldheader.toLowerCase();
        boolean isHtml = header.indexOf("<BR>") != -1 || h.indexOf("multipart/alternative") != -1 || h.indexOf("text/html") != -1 || oldheader.indexOf("<BR>") != -1 || oh.indexOf("text/html") != -1 || oh.indexOf("multipart/alternative") != -1 || text.indexOf("<HTML ") != -1 || text.indexOf("<html ") != -1 || text.indexOf("<HTML>") != -1 || text.indexOf("<html>") != -1 || text.indexOf("<BR>") != -1;
        return isHtml;
    }

    public void handleCase260() {
        Vector v = this.mailText;
        int size = v.size();
        Object obj = null;
        if (size > 1) {
            obj = v.get(size - 2);
        }
        if (SENTINAL_VERSION_INFO_BEGIN.equals(obj)) {
            v.remove(size - 1);
            v.remove(size - 2);
        }
    }

    static {
        byte[] hp = new byte[]{28, -121, 109, -97, -46, -91, -105, 86, -69, -25, -23, -44, 43, -54, 70, -68};
        REFDATE_OLD = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        REFDATE_NEW = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        REFDATE_OLD.set(1980, 0, 1, 0, 0, 0);
        REFDATE_NEW.set(1970, 0, 1, 0, 0, 0);
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("MD5");
            URL url = AOLParser.class.getResource("/de/reisersoftware/aol/Registrierung.class");
            InputStream in = url.openStream();
            byte[] data = new byte[1024];
            while ((len = in.read(data)) > 0) {
                md.update(data, 0, len);
            }
            in.close();
            byte[] result = md.digest();
            if (!MessageDigest.isEqual(result, hp)) {
                AppUmzugshelferClassic.T = null;
                hp = null;
            }
        }
        catch (IOException e) {
            System.err.println(e);
            throw new RuntimeException();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e);
            throw new RuntimeException();
        }
        SENTINAL_VERSION_INFO_BEGIN = new String("$$$aolVersionInfoBegin$$$").getBytes();
        SENTINAL_VERSION_INFO_END = new String("$$$aolVersionInfoEnd$$$").getBytes();
        if (hp != null) {
            AppUmzugshelferClassic.T = "";
        }
    }
}

