/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.aol;

import de.reisersoftware.aol.BinaryObject;
import de.reisersoftware.aol.MailParserException;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class RawASCIIObject {
    Hashtable binary_ = new Hashtable();
    byte[] textBytes_ = new byte[0];

    public RawASCIIObject(byte[] data) throws MailParserException {
        this.init(data);
    }

    private void init(byte[] data) throws MailParserException {
        ByteArrayOutputStream textBytesOutputStream = new ByteArrayOutputStream(data.length);
        boolean done = false;
        int pos = 0;
        int endPos = 0;
        try {
            while ((pos = this.binaryDataPosition(data, endPos)) != -1) {
                textBytesOutputStream.write(data, endPos, pos - endPos);
                endPos = this.extractBinaryData(data, pos);
            }
            textBytesOutputStream.write(data, endPos, data.length - endPos);
            this.textBytes_ = textBytesOutputStream.toByteArray();
        }
        catch (Exception e) {
            System.err.println("Fehler beim Auswerten von Binaerdaten:");
            System.err.println(e);
            this.binary_.clear();
            throw new MailParserException(e.toString());
        }
        catch (Throwable e) {
            System.err.println("Fehler beim Auswerten von Binaerdaten:");
            System.err.println(e);
            this.binary_.clear();
            throw new MailParserException(e.toString());
        }
    }

    private int extractBinaryData(byte[] data, int pos) throws Exception {
        int p;
        int len;
        pos += 8;
        do {
            for (p = pos; p < data.length && data[p] != 62; ++p) {
            }
            if (p >= data.length) {
                return p;
            }
            String dataTag = new String(data, pos, p - (pos - 1));
            len = BinaryObject.getLengthFromDataTag(dataTag);
            if (len > data.length || len < -1) {
                throw new Exception("Fehler: ung\u00fcltige L\u00e4ngenangabe in Inline-Bin\u00e4rdaten. (len=" + len + ")");
            }
            if (len == -1) continue;
            byte[] binDataItem = new byte[len];
            for (int i = 0; i < len; ++i) {
                binDataItem[i] = data[p + 1 + i];
            }
            if (!new String(data, len + p + 1, 7).equals("</DATA>")) {
                throw new Exception("Fehler: Inline-Binaerdaten unvollstaendig.");
            }
            String ID = BinaryObject.getIdFromDataTag(dataTag);
            String NAME = BinaryObject.getNameFromDataTag(dataTag);
            if (this.binary_.get(ID) == null) {
                Vector<byte[]> v = new Vector<byte[]>();
                v.addElement(binDataItem);
                this.binary_.put(ID, new BinaryObject(ID, NAME, v));
            } else {
                BinaryObject bObj = (BinaryObject)this.binary_.get(ID);
                bObj.addElement(binDataItem);
            }
            pos = len + p + 8;
        } while (len != -1);
        return p;
    }

    private int binaryDataPosition(byte[] data, int startPos) {
        int state = 0;
        block10: for (int pos = startPos; pos < data.length; ++pos) {
            int b = RawASCIIObject.unsignedByte(data[pos]);
            switch (state) {
                case 0: {
                    if (b == 60) {
                        state = 1;
                        continue block10;
                    }
                    state = 0;
                    continue block10;
                }
                case 1: {
                    if (b == 66) {
                        ++state;
                        continue block10;
                    }
                    if (b == 60) {
                        state = 1;
                        continue block10;
                    }
                    state = 0;
                    continue block10;
                }
                case 2: {
                    if (b == 73) {
                        ++state;
                        continue block10;
                    }
                    if (b == 60) {
                        state = 1;
                        continue block10;
                    }
                    state = 0;
                    continue block10;
                }
                case 3: {
                    if (b == 78) {
                        ++state;
                        continue block10;
                    }
                    if (b == 60) {
                        state = 1;
                        continue block10;
                    }
                    state = 0;
                    continue block10;
                }
                case 4: {
                    if (b == 65) {
                        ++state;
                        continue block10;
                    }
                    if (b == 60) {
                        state = 1;
                        continue block10;
                    }
                    state = 0;
                    continue block10;
                }
                case 5: {
                    if (b == 82) {
                        ++state;
                        continue block10;
                    }
                    if (b == 60) {
                        state = 1;
                        continue block10;
                    }
                    state = 0;
                    continue block10;
                }
                case 6: {
                    if (b == 89) {
                        ++state;
                        continue block10;
                    }
                    if (b == 60) {
                        state = 1;
                        continue block10;
                    }
                    state = 0;
                    continue block10;
                }
                case 7: {
                    if (b == 62) {
                        System.err.println("inline binary data found...");
                        return pos - 7;
                    }
                    state = b == 60 ? 1 : 0;
                }
            }
        }
        return -1;
    }

    public byte[] getTextBytes() {
        return this.textBytes_;
    }

    public Hashtable getBinary() {
        return this.binary_;
    }

    private static int unsignedByte(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }
}

