/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.aol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Registrierung {
    private static boolean wasChecked_ = false;
    private static boolean isRegistered_ = false;
    private static String licenseText_ = "";

    public static String getLicenseText() {
        Registrierung.isRegistered();
        return licenseText_;
    }

    private static String toHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            int value = (b[i] & 0x7F) + (b[i] < 0 ? 128 : 0);
            result = result + (value < 16 ? "0" : "");
            result = result + Integer.toHexString(value);
        }
        return result;
    }

    private static BigInteger[] readKey(BufferedReader din) throws IOException {
        BigInteger[] key = new BigInteger[]{new BigInteger(din.readLine(), 16), new BigInteger(din.readLine(), 16), new BigInteger(din.readLine(), 16)};
        return key;
    }

    private static boolean verifyMessage(BigInteger msg, BigInteger[] sign, BigInteger[] pubKey) {
        BigInteger p = pubKey[0];
        BigInteger g = pubKey[1];
        BigInteger y = pubKey[2];
        BigInteger r = sign[0];
        BigInteger s = sign[1];
        BigInteger p_minus_1 = p.subtract(BigInteger.ONE);
        if (BigInteger.ONE.compareTo(r) > 0 || r.compareTo(p_minus_1) > 0) {
            return false;
        }
        BigInteger v1 = y.modPow(r, p).multiply(r.modPow(s, p)).mod(p);
        BigInteger v2 = g.modPow(msg, p);
        return v1.equals(v2);
    }

    private static boolean verifyLicense(File licFile, BigInteger[] pubKey) throws IOException, NoSuchAlgorithmException {
        BufferedReader din = new BufferedReader(new FileReader(licFile));
        String messageString = "";
        String line = din.readLine();
        while (line != null && !line.trim().equals("BEGIN")) {
            line = din.readLine();
        }
        while (line != null && !line.trim().equals("")) {
            line = line.trim();
            messageString = messageString + line + "\r\n";
            line = din.readLine();
            if (line == null) continue;
            line = line.trim();
        }
        if (line == null) {
            throw new IOException("Unerwartetes Dateiende! (1)");
        }
        licenseText_ = messageString;
        byte[] message = messageString.getBytes();
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(message);
        byte[] mdig = md.digest();
        BigInteger digest1 = new BigInteger(Registrierung.toHexString(mdig), 16);
        String digestString = din.readLine();
        if (digestString == null) {
            throw new IOException("Unerwartetes Dateiende! (2)");
        }
        BigInteger digest2 = new BigInteger(digestString.trim(), 16);
        if (!digest1.equals(digest2)) {
            return false;
        }
        BigInteger[] sign = new BigInteger[2];
        String s1 = din.readLine();
        if (s1 == null) {
            throw new IOException("Unerwartetes Dateiende! (3)");
        }
        String s2 = din.readLine();
        if (s2 == null) {
            throw new IOException("Unerwartetes Dateiende! (4)");
        }
        if (s1.length() < 150 || s2.length() < 150) {
            return false;
        }
        sign[0] = new BigInteger(s1.trim(), 16);
        sign[1] = new BigInteger(s2.trim(), 16);
        return Registrierung.verifyMessage(digest1, sign, pubKey);
    }

    private static boolean checkIfRegistered() throws IOException, NoSuchAlgorithmException {
        File licFile = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "umzugshelfer.txt");
        if (!licFile.exists()) {
            licFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "umzugshelfer.txt");
        }
        if (!licFile.exists()) {
            return false;
        }
        URL url = Registrierung.class.getResource("/public.key");
        BufferedReader din = new BufferedReader(new InputStreamReader(url.openStream()));
        BigInteger[] pubKey = Registrierung.readKey(din);
        boolean result = Registrierung.verifyLicense(licFile, pubKey);
        if (!result) {
            throw new IOException("Signatur ung\u00fcltig oder nicht f\u00fcr die Version geeignet.");
        }
        return result;
    }

    public static boolean isRegistered() {
        if (wasChecked_) {
            return isRegistered_;
        }
        Registrierung.checkReg();
        wasChecked_ = true;
        return isRegistered_;
    }

    private static void checkReg() {
        try {
            isRegistered_ = false;
            isRegistered_ = Registrierung.checkIfRegistered();
        }
        catch (Exception e) {
            System.err.println(e);
            isRegistered_ = false;
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, "Fehler beim Lesen der Lizenz-Datei:\n" + e, "Lizenzdatei ung\u00fcltig", 2);
                    }
                });
            }
            catch (Exception ex1) {
                System.err.println(ex1);
            }
        }
        System.err.println(isRegistered_);
    }
}

