/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.aol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

class UnicodeTools {
    public static final int BUFFERSIZE = 8192;

    UnicodeTools() {
    }

    public static void unknownToUTF16(InputStream in_, OutputStream out) throws IOException {
        int b;
        PushbackInputStream in = new PushbackInputStream(in_);
        while (-1 != (b = in.read())) {
            int out2;
            int out1;
            int b2;
            if (b < 128) {
                out.write(0);
                out.write(b);
                continue;
            }
            if (b >= 194 && b <= 223) {
                b2 = in.read();
                if (b2 == -1) {
                    out.write(0);
                    out.write(b);
                    return;
                }
                if (b2 >= 128 && b2 <= 191) {
                    out1 = b - 192 >> 2;
                    out2 = ((b & 3) << 6) + b2 - 128;
                    out.write(out1);
                    out.write(out2);
                    continue;
                }
                out.write(0);
                out.write(b);
                in.unread(b2);
                continue;
            }
            if (b >= 224 && b <= 239) {
                b2 = in.read();
                if (b2 == -1) {
                    out.write(0);
                    out.write(b);
                    return;
                }
                if (b == 224 && b2 < 160) {
                    out.write(0);
                    out.write(b);
                    in.unread(b2);
                    continue;
                }
                if (b2 >= 128 && b2 <= 191) {
                    int b3 = in.read();
                    if (b3 == -1) {
                        out.write(0);
                        out.write(b);
                        out.write(0);
                        out.write(b2);
                        return;
                    }
                    if (b3 >= 128 && b3 <= 191) {
                        out1 = (b - 224 << 4) + (b2 - 128 >> 2);
                        out2 = ((b2 & 3) << 6) + b3 - 128;
                        out.write(out1);
                        out.write(out2);
                        continue;
                    }
                    out.write(0);
                    out.write(b);
                    in.unread(b2);
                    in.unread(b3);
                    continue;
                }
                out.write(0);
                out.write(b);
                in.unread(b2);
                continue;
            }
            out.write(0);
            out.write(b);
        }
    }

    public static void UTF16ToUTF8(InputStream in, OutputStream out) throws IOException {
        int b1;
        while (-1 != (b1 = in.read())) {
            int out2;
            int out1;
            int b2 = in.read();
            if (b2 == -1) {
                throw new IOException("Unexpected end of UTC-16BE stream.");
            }
            if (b1 == 0) {
                if (b2 < 128) {
                    out.write(b2);
                    continue;
                }
                if (b2 < 192) {
                    out.write(194);
                    out.write(b2);
                    continue;
                }
                out.write(195);
                out.write(b2 - 64);
                continue;
            }
            if (b1 < 8) {
                out1 = 192 + (b1 << 2) + (b2 >> 6);
                out2 = (b2 & 0x3F) + 128;
                out.write(out1);
                out.write(out2);
                continue;
            }
            int high = b1 >> 4;
            int low = b1 & 0xF;
            out1 = 224 + high;
            out2 = 128 + ((low << 8 | b2) >> 6);
            int out3 = (b2 & 0x3F) + 128;
            out.write(out1);
            out.write(out2);
            out.write(out3);
        }
    }

    public static void unknownToUTF8(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        while (-1 != (count = in.read(buffer))) {
            ByteArrayInputStream bIn = new ByteArrayInputStream(buffer, 0, count);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(16384);
            UnicodeTools.unknownToUTF16(bIn, bOut);
            byte[] bufferUTF16 = bOut.toByteArray();
            bIn = new ByteArrayInputStream(bufferUTF16);
            UnicodeTools.UTF16ToUTF8(bIn, out);
        }
    }

    public static byte[] unknownToUTF8(byte[] source) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(source);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(source.length * 2);
            UnicodeTools.unknownToUTF16(bIn, bOut);
            byte[] bufferUTF16 = bOut.toByteArray();
            bIn = new ByteArrayInputStream(bufferUTF16);
            bOut = new ByteArrayOutputStream(bufferUTF16.length * 2);
            UnicodeTools.UTF16ToUTF8(bIn, bOut);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            System.err.println(e);
            System.err.println("there was an error during conversion -- returning source-bytes instead");
            return source;
        }
    }

    public static byte[] unknownToUTF8(byte[] source, int begin, int len) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(source, begin, len);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(source.length * 2);
            UnicodeTools.unknownToUTF16(bIn, bOut);
            byte[] bufferUTF16 = bOut.toByteArray();
            bIn = new ByteArrayInputStream(bufferUTF16);
            bOut = new ByteArrayOutputStream(bufferUTF16.length * 2);
            UnicodeTools.UTF16ToUTF8(bIn, bOut);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            System.err.println(e);
            System.err.println("there was an error during conversion -- returning source-bytes instead");
            byte[] partSource = new byte[len];
            for (int i = 0; i < len; ++i) {
                partSource[i] = source[begin + i];
            }
            return partSource;
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1 || !args[0].equals("to16") && !args[0].equals("to8")) {
                System.out.println("Parameter: to16 oder to8!");
                System.exit(1);
            }
            if (args[0].equals("to16")) {
                System.err.println("Converting from unknown (UTF8 or ASCII) to UTF16.");
                UnicodeTools.unknownToUTF16(System.in, System.out);
            } else {
                System.err.println("Converting from UTF16 to UTF8.");
                UnicodeTools.UTF16ToUTF8(System.in, System.out);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static String utf8encodeWord(byte[] src) {
        int len = src.length;
        boolean encode = false;
        for (int i = 0; i < len; ++i) {
            if (UnicodeTools.toUnsignedInt(src[i]) <= 127) continue;
            encode = true;
            break;
        }
        if (!encode) {
            return new String(src);
        }
        String result = "=?utf-8?Q?";
        int curLen = 10;
        block4: for (int i = 0; i < len; ++i) {
            int ch = UnicodeTools.toUnsignedInt(src[i]);
            if (curLen > 65) {
                if (ch <= 127) {
                    result = result + "?= \r\n   =?utf-8?Q?";
                    curLen = 10;
                } else if (ch >= 194 && ch <= 239) {
                    result = result + "?= \r\n   =?utf-8?Q?";
                    curLen = 10;
                }
            }
            if (ch > 127 || ch < 48) {
                if (ch == 32) {
                    result = result + "_";
                    ++curLen;
                    continue;
                }
                result = result + "=" + UnicodeTools.hexString(ch);
                curLen += 3;
                continue;
            }
            switch (ch) {
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 123: 
                case 124: 
                case 125: 
                case 127: {
                    result = result + "=" + UnicodeTools.hexString(ch);
                    curLen += 3;
                    continue block4;
                }
                default: {
                    result = result + (char)ch;
                    ++curLen;
                }
            }
        }
        return result + "?=";
    }

    private static String hexString(int ch) {
        String result = ch < 16 ? "0" : "";
        result = result + Integer.toHexString(ch).toUpperCase();
        return result;
    }

    public static int toUnsignedInt(byte value) {
        return (value & 0x7F) + (value < 0 ? 128 : 0);
    }
}

