/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.pop3server;

import de.reisersoftware.pop3server.DirectoryWatcher;
import de.reisersoftware.pop3server.Message;
import de.reisersoftware.tools.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.Adler32;

public class MailStore {
    private static final String FILE_EXTENSION = ".eml";
    private Thread owner_ = null;
    private String user_;
    private String pass_;
    private DirectoryWatcher mailDirWatcher_;
    private Vector messages_ = new Vector();

    public synchronized boolean lock(Thread newOwner) throws IOException {
        if (this.owner_ == null || !this.owner_.isAlive()) {
            this.owner_ = newOwner;
            this.refresh();
            return true;
        }
        return false;
    }

    public synchronized void unlock() {
        this.owner_ = null;
    }

    public boolean verify(String user, String pass) {
        return this.user_.equalsIgnoreCase(user) && this.pass_.equals(pass);
    }

    public MailStore(String user, String pass, DirectoryWatcher mailDirWatcher) throws IOException {
        if (!mailDirWatcher.getDir().isDirectory()) {
            throw new IOException("'" + mailDirWatcher.getDir() + "' is not an existing directory");
        }
        this.user_ = user;
        this.pass_ = pass;
        this.mailDirWatcher_ = mailDirWatcher;
        this.init();
    }

    private synchronized void init() throws IOException {
        if (this.mailDirWatcher_ == null) {
            return;
        }
        this.messages_.clear();
        File[] files = this.mailDirWatcher_.listFiles();
        int number = 0;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().toLowerCase().endsWith(FILE_EXTENSION) || !files[i].isFile()) continue;
            try {
                Message msg = new Message(files[i]);
                ++number;
                this.messages_.addElement(msg);
                continue;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }

    public synchronized void refresh() throws IOException {
        this.init();
    }

    public synchronized void disableMailstore() {
        this.owner_ = null;
        this.messages_.clear();
        this.mailDirWatcher_ = null;
    }

    public long getSize(int number) {
        if (number < 1 || number > this.messages_.size()) {
            return -1L;
        }
        return ((Message)this.messages_.elementAt(number - 1)).getSize();
    }

    public long getSize() {
        long sum = 0L;
        Enumeration e = this.messages_.elements();
        while (e.hasMoreElements()) {
            Message msg = (Message)e.nextElement();
            if (msg.isDeleted()) continue;
            sum += msg.getSize();
        }
        return sum;
    }

    public long count() {
        int count = 0;
        Enumeration e = this.messages_.elements();
        while (e.hasMoreElements()) {
            if (((Message)e.nextElement()).isDeleted()) continue;
            ++count;
        }
        return count;
    }

    public boolean markDeleted(int num) {
        if (num < 1 || num > this.messages_.size()) {
            return false;
        }
        Message msg = (Message)this.messages_.elementAt(num - 1);
        if (msg.isDeleted()) {
            return false;
        }
        msg.markDeleted();
        return true;
    }

    public boolean deleteFiles() throws IOException {
        boolean success = true;
        Enumeration e = this.messages_.elements();
        while (e.hasMoreElements()) {
            Message msg = (Message)e.nextElement();
            if (!msg.isDeleted() || msg.deleteFile()) continue;
            success = false;
            break;
        }
        this.refresh();
        return success;
    }

    public void undelete() {
        Enumeration e = this.messages_.elements();
        while (e.hasMoreElements()) {
            Message msg = (Message)e.nextElement();
            msg.undelete();
        }
    }

    public Message getMessage(int number) {
        if (number < 1 || number > this.messages_.size()) {
            return null;
        }
        Message msg = (Message)this.messages_.elementAt(number - 1);
        if (msg.isDeleted()) {
            return null;
        }
        return msg;
    }

    public Vector getMessages() {
        return this.messages_;
    }

    public static long getAdler32(File file) throws FileNotFoundException, IOException {
        int count;
        Adler32 adler32 = new Adler32();
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[16384];
        while ((count = in.read(buf)) > -1) {
            adler32.update(buf, 0, count);
        }
        in.close();
        return adler32.getValue();
    }

    public static File moveFile_OrDeleteIfDuplicate(File file, long adler32) {
        Object[] obj = MailStore.getNextAdler32File(file, adler32, file.getParentFile());
        File theNewFile = (File)obj[0];
        ArrayList filesWithSameAdler32 = (ArrayList)obj[1];
        if (MailStore.equalsAny(file, filesWithSameAdler32)) {
            file.delete();
            return null;
        }
        file.renameTo(theNewFile);
        return theNewFile;
    }

    public static File copyFile_IfNoDuplicates(File file, long adler32, File dest) throws IOException {
        Object[] obj = MailStore.getNextAdler32File(file, adler32, dest);
        File theNewFile = (File)obj[0];
        ArrayList filesWithSameAdler32 = (ArrayList)obj[1];
        if (MailStore.equalsAny(file, filesWithSameAdler32)) {
            return null;
        }
        Tools.copyFile(file, theNewFile);
        return theNewFile;
    }

    private static Object[] getNextAdler32File(File file, long adler32, File dest) {
        File theNewFile;
        Object[] result = new Object[2];
        ArrayList<File> filesWithSameAdler32 = new ArrayList<File>();
        int i = 0;
        while (true) {
            if (!(theNewFile = new File(dest, adler32 + "-" + i + FILE_EXTENSION)).exists()) break;
            ++i;
            filesWithSameAdler32.add(theNewFile);
        }
        result[0] = theNewFile;
        result[1] = filesWithSameAdler32;
        return result;
    }

    private static boolean equalsAny(File file, ArrayList files) {
        for (Object f : files) {
            try {
                if (!MailStore.compareFiles(file, (File)f)) continue;
                return true;
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
        return false;
    }

    public static boolean compareFiles(File a, File b) throws IOException {
        if (a.length() != b.length()) {
            return false;
        }
        FileInputStream inA = new FileInputStream(a);
        FileInputStream inB = new FileInputStream(b);
        byte[] bufA = new byte[4096];
        byte[] bufB = new byte[bufA.length];
        boolean result = true;
        boolean done = false;
        block0: while (!done) {
            int count = inA.read(bufA);
            if (count < 0) {
                done = true;
            }
            if (inB.read(bufB) != count) {
                done = true;
                result = false;
            }
            for (int i = 0; i < count; ++i) {
                if (bufA[i] == bufB[i]) continue;
                done = true;
                result = false;
                continue block0;
            }
        }
        inA.close();
        inB.close();
        return result;
    }

    public static boolean isMailDirectory(File directory) {
        if (!directory.canRead() || !directory.isDirectory()) {
            return false;
        }
        File[] files = directory.listFiles();
        if (files.length == 0) {
            return true;
        }
        for (File theFile : files) {
            if (theFile.getName().toLowerCase().endsWith(FILE_EXTENSION)) continue;
            return false;
        }
        return true;
    }
}

