/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.pop3server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Message {
    private File file_;
    private String hash_ = null;
    private boolean deleted_;
    private long size_;

    public Message(File file) {
        this.file_ = file;
        this.size_ = this.file_.length();
        this.deleted_ = false;
    }

    public void markDeleted() {
        this.deleted_ = true;
    }

    public void undelete() {
        this.deleted_ = false;
    }

    public boolean isDeleted() {
        return this.deleted_;
    }

    public boolean deleteFile() {
        return this.file_.delete();
    }

    public long getSize() {
        return this.size_;
    }

    public String getHash() throws IOException {
        try {
            if (this.hash_ == null) {
                this.hash_ = Message.md5sum(this.file_);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex);
        }
        return this.hash_;
    }

    public BufferedReader getContent() throws IOException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(this.file_)));
    }

    public static String md5sum(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest md5 = MessageDigest.getInstance("md5");
        DigestInputStream din = new DigestInputStream(new FileInputStream(file), md5);
        din.on(true);
        byte[] buf = new byte[65536];
        while (din.read(buf) > 0) {
        }
        din.close();
        return Message.toHexString(md5.digest());
    }

    public static String toHexString(byte[] b) {
        StringBuffer buf = new StringBuffer(b.length * 2 + 16);
        for (int i = 0; i < b.length; ++i) {
            int value = (b[i] & 0x7F) + (b[i] < 0 ? 128 : 0);
            if (value < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(value).toUpperCase());
        }
        return buf.toString();
    }
}

