/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.tools;

import de.reisersoftware.tools.filefinder.FileExtFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.zip.Adler32;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class Tools {
    private static final int BUFFERSIZE = 4096;
    private static Random rnd_ = new Random();

    public static File chooseMboxOutputFile(JFileChooser fc) {
        File outFile = fc.getSelectedFile();
        if (outFile == null) {
            outFile = new File(fc.getCurrentDirectory(), "aolexport.mbox");
        }
        fc.setSelectedFile(outFile);
        fc.setDialogTitle("MBOX-Datei speichern");
        fc.setFileSelectionMode(0);
        fc.resetChoosableFileFilters();
        fc.setFileFilter(new FileExtFilter("Unix-Mailbox-Format (*.mbox, *.mbx)", new String[]{"mbox", "mbx"}));
        fc.setDialogType(1);
        fc.setMultiSelectionEnabled(false);
        outFile = null;
        boolean done = false;
        while (!done) {
            if (fc.showSaveDialog(null) == 0) {
                File selFile = fc.getSelectedFile();
                if (!selFile.exists()) {
                    outFile = selFile;
                    done = true;
                    continue;
                }
                int response = JOptionPane.showConfirmDialog(null, "Die Datei '" + selFile.getName() + "' existiert " + "bereits. Soll sie \u00fcberschrieben werden?", "Ausgabedatei existiert bereits.", 1, 3);
                if (response == 0) {
                    outFile = selFile;
                    done = true;
                    continue;
                }
                if (response != 2) continue;
                outFile = null;
                done = true;
                continue;
            }
            outFile = null;
            done = true;
        }
        return outFile;
    }

    public static File getRandomFileName(File directory, String extension) {
        File theFile;
        while ((theFile = new File(directory, Math.abs(rnd_.nextLong()) + extension)).exists()) {
        }
        return theFile;
    }

    public static long copyFile(File src, File dest) throws IOException {
        int count;
        Adler32 adler32 = new Adler32();
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buf = new byte[4096];
        while ((count = in.read(buf)) > -1) {
            out.write(buf, 0, count);
            adler32.update(buf, 0, count);
        }
        out.close();
        in.close();
        return adler32.getValue();
    }
}

