/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.tools.dirchooser;

import java.io.File;
import java.util.Enumeration;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FileSystemTreeNode
extends DefaultMutableTreeNode {
    private FileSystemView fsv_;
    private File file_;
    private static final Object DUMMY_NODE = new Object();

    FileSystemTreeNode(File file, FileSystemView fsv) {
        this.fsv_ = fsv;
        this.file_ = file;
        if (this.file_ != null && this.file_.isDirectory()) {
            this.addDummy();
        }
    }

    public String toString() {
        if (this.file_ == null) {
            return null;
        }
        return this.fsv_.getSystemDisplayName(this.file_);
    }

    public File getFile() {
        return this.file_;
    }

    public void reloadChildren() {
        this.removeAllChildren();
        this.addDummy();
        this.loadChildren();
    }

    public void loadChildren() {
        if (this.getChildCount() == 1 && DUMMY_NODE == ((FileSystemTreeNode)this.getChildAt(0)).getUserObject()) {
            File[] list;
            this.remove(0);
            for (File theFile : list = this.file_.listFiles()) {
                if (!theFile.isDirectory()) continue;
                this.add(new FileSystemTreeNode(theFile, this.fsv_));
            }
        }
    }

    private void addDummy() {
        FileSystemTreeNode dummy = new FileSystemTreeNode(null, this.fsv_);
        dummy.setUserObject(DUMMY_NODE);
        this.add(dummy);
    }

    FileSystemTreeNode findChildFile(File file) {
        if (this.children == null) {
            return null;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            FileSystemTreeNode child = (FileSystemTreeNode)e.nextElement();
            if (!child.getFile().equals(file)) continue;
            return child;
        }
        return null;
    }
}

