/*
 * Decompiled with CFR 0.152.
 */
package de.reisersoftware.tools.dirchooser;

import de.reisersoftware.tools.dirchooser.FileSystemTreeNode;
import de.reisersoftware.umzugshelferclassic.AppUmzugshelferClassic;
import de.reisersoftware.umzugshelferclassic.UmzugshelferClassicView;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class JDialogDirectoryChooser
extends JDialog {
    private File selectedFolder_ = null;
    private DefaultTreeModel model_ = new DefaultTreeModel(null);
    private static FileSystemView fsv = FileSystemView.getFileSystemView();
    private JButton jButtonCancel;
    private JButton jButtonNewFolder;
    private JButton jButtonOk;
    private JScrollPane jScrollPane1;
    private JTree jTree1;

    public File getSelectedFolder() {
        return this.selectedFolder_;
    }

    public String getSelectedFolderName() {
        return fsv.getSystemDisplayName(this.selectedFolder_);
    }

    public JDialogDirectoryChooser(Frame parent, boolean modal) {
        super(parent, modal);
        File[] roots;
        this.initComponents();
        DefaultTreeCellRenderer cr = new DefaultTreeCellRenderer();
        cr.setLeafIcon(cr.getClosedIcon());
        this.jTree1.setCellRenderer(cr);
        FileSystemTreeNode rootNode = new FileSystemTreeNode(null, fsv);
        for (File theRoot : roots = fsv.getRoots()) {
            FileSystemTreeNode theNode = new FileSystemTreeNode(theRoot, fsv);
            rootNode.add(theNode);
            theNode.loadChildren();
        }
        this.model_.setRoot(rootNode);
        this.jTree1.setModel(this.model_);
        if (this.jTree1.getRowCount() > 0) {
            this.jTree1.expandRow(0);
            this.jTree1.setSelectionRow(0);
        }
        this.setIconImage(UmzugshelferClassicView.getMyFrameIcon());
    }

    private void initComponents() {
        this.jButtonNewFolder = new JButton();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(AppUmzugshelferClassic.class).getContext().getResourceMap(JDialogDirectoryChooser.class);
        this.jButtonNewFolder.setIcon(resourceMap.getIcon("jButtonNewFolder.icon"));
        this.jButtonNewFolder.setText(resourceMap.getString("jButtonNewFolder.text", new Object[0]));
        this.jButtonNewFolder.setName("jButtonNewFolder");
        this.jButtonNewFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogDirectoryChooser.this.jButtonNewFolderActionPerformed(evt);
            }
        });
        this.jButtonOk.setIcon(resourceMap.getIcon("jButtonOk.icon"));
        this.jButtonOk.setMnemonic('o');
        this.jButtonOk.setText(resourceMap.getString("jButtonOk.text", new Object[0]));
        this.jButtonOk.setName("jButtonOk");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogDirectoryChooser.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setIcon(resourceMap.getIcon("jButtonCancel.icon"));
        this.jButtonCancel.setText(resourceMap.getString("jButtonCancel.text", new Object[0]));
        this.jButtonCancel.setName("jButtonCancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogDirectoryChooser.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.jTree1.setModel(null);
        this.jTree1.setName("jTree1");
        this.jTree1.setRootVisible(false);
        this.jTree1.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
            }

            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                JDialogDirectoryChooser.this.jTree1TreeWillExpand(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 436, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonNewFolder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 111, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 445, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonNewFolder).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap()));
        this.pack();
    }

    private void jButtonNewFolderActionPerformed(ActionEvent evt) {
        String name;
        TreePath path = this.jTree1.getSelectionPath();
        if (path == null) {
            return;
        }
        FileSystemTreeNode node = (FileSystemTreeNode)path.getLastPathComponent();
        File parentFolder = node.getFile();
        File newFolder = new File(parentFolder, "Neuer Ordner");
        int i = 0;
        while (newFolder.exists()) {
            newFolder = new File(parentFolder, "Neuer Ordner (" + ++i + ")");
        }
        if (!newFolder.mkdir()) {
            JOptionPane.showMessageDialog(this, "In '" + node + "' konnte kein neuer Ordner angelegt werden.", "Fehler", 0);
            return;
        }
        while (true) {
            if ((name = JOptionPane.showInputDialog(this, "Ordnername:", newFolder.getName())) == null) {
                newFolder.delete();
                return;
            }
            if (newFolder.renameTo(new File(parentFolder, name))) break;
            JOptionPane.showMessageDialog(this, "'" + newFolder.getName() + "' konnte nicht in " + "'" + name + "' umbenannt werden.", "Fehler", 0);
        }
        newFolder = new File(parentFolder, name);
        node.reloadChildren();
        this.model_.reload(node);
        this.jTree1.expandPath(path);
        FileSystemTreeNode child = node.findChildFile(newFolder);
        if (child != null) {
            TreePath newNodePath = path.pathByAddingChild(child);
            if (newNodePath != null) {
                this.jTree1.setSelectionPath(newNodePath);
            }
            this.jTree1.expandPath(newNodePath);
        }
    }

    private void jTree1TreeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
        TreePath path = evt.getPath();
        if (path == null) {
            return;
        }
        FileSystemTreeNode node = (FileSystemTreeNode)path.getPathComponent(path.getPathCount() - 1);
        this.setCursor(new Cursor(3));
        node.loadChildren();
        this.model_.reload(node);
        this.setCursor(new Cursor(0));
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selectedFolder_ = null;
        this.setVisible(false);
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        FileSystemTreeNode node;
        TreePath path = this.jTree1.getSelectionPath();
        if (path != null && (node = (FileSystemTreeNode)path.getPathComponent(path.getPathCount() - 1)) != null) {
            this.selectedFolder_ = node.getFile();
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JDialogDirectoryChooser dialog = new JDialogDirectoryChooser(null, true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                System.err.println("davor...");
                dialog.setVisible(true);
                System.err.println("danach...");
            }
        });
    }
}

